<?php
require_once 'config/config.php';

// Check if user is already logged in
if (isLoggedIn()) {
    redirect('dashboard.php');
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - <?php echo APP_DESC; ?></title>
    <?php if (!empty(APP_FAVICON)): ?>
    <link rel="icon" type="image/x-icon" href="<?php echo htmlspecialchars(APP_FAVICON); ?>">
    <?php endif; ?>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="landing-page">
    <div class="landing-container">
        <!-- Header -->
        <header class="landing-header">
            <div class="cloud-animation">
                <div class="cloud cloud1"></div>
                <div class="cloud cloud2"></div>
                <div class="cloud cloud3"></div>
            </div>
            <div class="app-title">
                <?php if (!empty(APP_LOGO)): ?>
                <div style="margin-bottom: 20px;">
                    <img src="<?php echo htmlspecialchars(APP_LOGO); ?>" alt="Logo" style="max-height: 100px; max-width: 300px;">
                </div>
                <?php endif; ?>
                <h1><?php if (empty(APP_LOGO)): ?><i class="fas fa-tint"></i> <?php endif; ?><?php echo APP_NAME; ?></h1>
                <p class="app-subtitle"><?php echo APP_DESC; ?></p>
            </div>
        </header>

        <!-- Main Content -->
        <main class="landing-content">
            <div class="landing-card">
                <div class="card-header">
                    <h2>Selamat Datang</h2>
                    <p>Sistem Peringatan Dini Kekeringan & Manajemen Air Desa</p>
                </div>

                <div class="auth-tabs">
                    <button class="tab-btn active" data-tab="login">Masuk</button>
                    <button class="tab-btn" data-tab="register">Daftar</button>
                </div>

                <!-- Login Form -->
                <div class="tab-content active" id="login-tab">
                    <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger" style="margin-bottom: 20px;">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                    </div>
                    <?php endif; ?>
                    <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success" style="margin-bottom: 20px;">
                        <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                    </div>
                    <?php endif; ?>
                    <form action="auth/login.php" method="POST" class="auth-form">
                        <div class="form-group">
                            <label><i class="fas fa-user"></i> Username</label>
                            <input type="text" name="username" required autocomplete="username">
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-lock"></i> Password</label>
                            <input type="password" name="password" required autocomplete="current-password">
                        </div>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fas fa-sign-in-alt"></i> Masuk
                        </button>
                    </form>
                </div>

                <!-- Register Form -->
                <div class="tab-content" id="register-tab">
                    <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger" style="margin-bottom: 20px;">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                    </div>
                    <?php endif; ?>
                    <form action="auth/register.php" method="POST" class="auth-form" id="registerForm">
                        <input type="hidden" name="latitude" id="reg_latitude">
                        <input type="hidden" name="longitude" id="reg_longitude">
                        <div class="form-group">
                            <label><i class="fas fa-user"></i> Username <span style="color: red;">*</span></label>
                            <input type="text" name="username" required>
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-id-card"></i> Nama Lengkap <span style="color: red;">*</span></label>
                            <input type="text" name="nama_lengkap" required>
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-id-badge"></i> Nomor KTP <span style="color: red;">*</span></label>
                            <input type="text" name="no_ktp" required maxlength="16" pattern="[0-9]{16}" placeholder="16 digit angka">
                            <small style="color: #666; display: block; margin-top: 5px;">16 digit nomor KTP</small>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label><i class="fas fa-map"></i> Provinsi</label>
                                <input type="text" name="provinsi" placeholder="Contoh: DI Yogyakarta">
                            </div>
                            <div class="form-group">
                                <label><i class="fas fa-city"></i> Kabupaten</label>
                                <input type="text" name="kabupaten" placeholder="Contoh: Gunungkidul">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label><i class="fas fa-building"></i> Kelurahan</label>
                                <input type="text" name="kelurahan" placeholder="Nama Kelurahan">
                            </div>
                            <div class="form-group">
                                <label><i class="fas fa-map-marker-alt"></i> Dusun</label>
                                <select name="dusun_id" id="dusun_select">
                                    <option value="">Pilih Dusun</option>
                                    <?php
                                    $db = Database::getInstance()->getConnection();
                                    $stmt = $db->query("SELECT d.*, des.nama_desa FROM dusun d JOIN desa des ON d.desa_id = des.id ORDER BY des.nama_desa, d.nama_dusun");
                                    $dusun_list = $stmt->fetchAll();
                                    foreach ($dusun_list as $dusun):
                                    ?>
                                    <option value="<?php echo $dusun['id']; ?>"><?php echo htmlspecialchars($dusun['nama_desa']); ?> - <?php echo htmlspecialchars($dusun['nama_dusun']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label><i class="fas fa-home"></i> RT</label>
                                <input type="text" name="rt" placeholder="Contoh: 01" maxlength="10">
                            </div>
                            <div class="form-group">
                                <label><i class="fas fa-home"></i> RW</label>
                                <input type="text" name="rw" placeholder="Contoh: 05" maxlength="10">
                            </div>
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-envelope"></i> Email</label>
                            <input type="email" name="email">
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-phone"></i> No. HP</label>
                            <input type="text" name="no_hp" placeholder="Contoh: 081234567890">
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-lock"></i> Password <span style="color: red;">*</span></label>
                            <input type="password" name="password" required minlength="6">
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-lock"></i> Konfirmasi Password <span style="color: red;">*</span></label>
                            <input type="password" name="password_confirm" required>
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-map-marker-alt"></i> Lokasi GPS</label>
                            <div class="form-row">
                                <div class="form-group">
                                    <input type="text" id="reg_lat_display" placeholder="Latitude" readonly style="background: #f5f5f5; font-size: 0.9rem;">
                                </div>
                                <div class="form-group">
                                    <input type="text" id="reg_lng_display" placeholder="Longitude" readonly style="background: #f5f5f5; font-size: 0.9rem;">
                                </div>
                            </div>
                            <small style="color: #666; display: block; margin-top: 5px;">
                                <i class="fas fa-info-circle"></i> Koordinat GPS akan diambil otomatis dari perangkat Anda
                            </small>
                        </div>
                        <button type="submit" class="btn btn-success btn-block">
                            <i class="fas fa-user-plus"></i> Daftar
                        </button>
                        <small style="color: #666; display: block; margin-top: 10px; text-align: center;">
                            <span style="color: red;">*</span> Wajib diisi
                        </small>
                    </form>
                </div>
            </div>

            <!-- App Information -->
            <div class="app-info-section">
                <h2 style="text-align: center; color: white; margin-bottom: 30px;">
                    <i class="fas fa-info-circle"></i> Informasi Aplikasi
                </h2>
                <div class="info-grid">
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-brain"></i>
                        </div>
                        <h3>AI Prediksi Kekeringan</h3>
                        <p>Sistem menggunakan kecerdasan buatan untuk memprediksi risiko kekeringan 7 hari ke depan berdasarkan data curah hujan, kelembapan tanah, dan laporan warga.</p>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-map-marked-alt"></i>
                        </div>
                        <h3>Peta Real-Time</h3>
                        <p>Pantau kondisi semua desa dan dusun secara real-time dengan peta interaktif. Zona kering ditandai dengan warna merah, waspada kuning, dan aman hijau.</p>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-bell"></i>
                        </div>
                        <h3>Notifikasi Peringatan</h3>
                        <p>Dapatkan notifikasi peringatan dini ketika daerah Anda berisiko mengalami kekeringan, sehingga Anda dapat menghemat air lebih awal.</p>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-truck"></i>
                        </div>
                        <h3>Manajemen Distribusi</h3>
                        <p>AI membantu menjadwalkan distribusi air tangki secara efisien berdasarkan prioritas zona kering, menghemat biaya BBM dan tenaga.</p>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-camera"></i>
                        </div>
                        <h3>Laporan dengan Foto</h3>
                        <p>Warga dapat melaporkan kondisi air di penampungan, sumur, atau PAM dengan foto dan koordinat GPS otomatis untuk verifikasi yang lebih akurat.</p>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-chart-bar"></i>
                        </div>
                        <h3>Dashboard Lengkap</h3>
                        <p>Admin dan pemdes dapat melihat statistik lengkap, export laporan PDF/Excel, dan mengelola semua data dengan mudah.</p>
                    </div>
                </div>
            </div>

            <!-- Petunjuk Penggunaan -->
            <div class="guide-section">
                <h2 style="text-align: center; color: white; margin-bottom: 30px;">
                    <i class="fas fa-book"></i> Petunjuk Penggunaan
                </h2>
                <div class="guide-steps">
                    <div class="guide-step">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            <h3><i class="fas fa-user-plus"></i> Daftar Akun</h3>
                            <p>Klik tab "Daftar" dan isi formulir pendaftaran. Hanya warga yang dapat mendaftar sendiri. Akun lain dibuat oleh admin.</p>
                        </div>
                    </div>
                    <div class="guide-step">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            <h3><i class="fas fa-sign-in-alt"></i> Login</h3>
                            <p>Setelah mendaftar, gunakan username dan password untuk login ke sistem.</p>
                        </div>
                    </div>
                    <div class="guide-step">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            <h3><i class="fas fa-file-alt"></i> Buat Laporan</h3>
                            <p>Klik "Buat Laporan" untuk melaporkan kondisi air. Anda dapat upload foto dari kamera atau galeri, dan koordinat akan terdeteksi otomatis.</p>
                        </div>
                    </div>
                    <div class="guide-step">
                        <div class="step-number">4</div>
                        <div class="step-content">
                            <h3><i class="fas fa-chart-line"></i> Lihat Prediksi</h3>
                            <p>Pantau prediksi kekeringan di daerah Anda untuk mengetahui kapan harus menghemat air.</p>
                        </div>
                    </div>
                    <div class="guide-step">
                        <div class="step-number">5</div>
                        <div class="step-content">
                            <h3><i class="fas fa-bell"></i> Terima Notifikasi</h3>
                            <p>Anda akan menerima notifikasi ketika ada peringatan kekeringan atau update penting lainnya.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Features -->
            <div class="features-grid">
                <div class="feature-card">
                    <i class="fas fa-brain"></i>
                    <h3>AI Prediksi</h3>
                    <p>Prediksi risiko kekeringan 7 hari ke depan</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-map"></i>
                    <h3>Peta Real-Time</h3>
                    <p>Monitoring kondisi desa secara real-time</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-bell"></i>
                    <h3>Notifikasi</h3>
                    <p>Peringatan dini untuk hemat air</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-truck"></i>
                    <h3>Manajemen Tangki</h3>
                    <p>Penjadwalan distribusi air yang efisien</p>
                </div>
            </div>
        </main>

        <!-- Footer -->
        <footer class="landing-footer">
            <p>@2025 <strong>Skipotech Innovation</strong>. All rights reserved.</p>
        </footer>
    </div>

    <script src="assets/js/main.js"></script>
    <script>
    // Auto get GPS location on register tab
    document.addEventListener('DOMContentLoaded', function() {
        const registerTab = document.getElementById('register-tab');
        const tabButtons = document.querySelectorAll('.tab-btn');
        
        // Get GPS when register tab is clicked
        tabButtons.forEach(btn => {
            if (btn.getAttribute('data-tab') === 'register') {
                btn.addEventListener('click', function() {
                    setTimeout(getRegisterLocation, 500);
                });
            }
        });
        
        // Also get location when register form is visible
        if (registerTab && registerTab.classList.contains('active')) {
            getRegisterLocation();
        }
    });
    
    function getRegisterLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    const lat = position.coords.latitude;
                    const lng = position.coords.longitude;
                    
                    document.getElementById('reg_latitude').value = lat;
                    document.getElementById('reg_longitude').value = lng;
                    document.getElementById('reg_lat_display').value = lat.toFixed(6);
                    document.getElementById('reg_lng_display').value = lng.toFixed(6);
                },
                function(error) {
                    console.log('GPS error:', error.message);
                    // Don't show error, just leave empty
                }
            );
        }
    }
    </script>
</body>
</html>

