<?php
// Dynamic Sidebar based on user role
$current_page = basename($_SERVER['PHP_SELF']);
$current_path = $_SERVER['REQUEST_URI'];
?>
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <h2>
            <?php if (!empty(APP_LOGO)): ?>
            <img src="<?php echo htmlspecialchars(APP_LOGO); ?>" alt="Logo" style="max-height: 40px; max-width: 150px; vertical-align: middle; margin-right: 10px;">
            <?php else: ?>
            <i class="fas fa-tint"></i>
            <?php endif; ?>
            <?php echo APP_NAME; ?>
        </h2>
        <small style="color: rgba(255,255,255,0.7); font-size: 0.8rem;">
            <?php echo ucfirst(getUserRole() ?? 'guest'); ?>
        </small>
    </div>
    <nav class="sidebar-nav">
        <a href="<?php echo strpos($current_path, 'admin') !== false || strpos($current_path, 'petugas') !== false || strpos($current_path, 'distribusi') !== false || strpos($current_path, 'prediksi') !== false || strpos($current_path, 'peta') !== false || strpos($current_path, 'laporan') !== false || strpos($current_path, 'notifikasi') !== false ? '../dashboard.php' : 'dashboard.php'; ?>" class="nav-item <?php echo $current_page === 'dashboard.php' ? 'active' : ''; ?>">
            <i class="fas fa-home"></i>
            <span>Dashboard</span>
        </a>
        
        <?php if (isAdmin()): ?>
        <!-- Admin Menu -->
        <a href="../prediksi/index.php" class="nav-item <?php echo strpos($current_page, 'prediksi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-chart-line"></i>
            <span>Prediksi Kekeringan</span>
        </a>
        <a href="../peta/index.php" class="nav-item <?php echo strpos($current_page, 'peta') !== false ? 'active' : ''; ?>">
            <i class="fas fa-map-marked-alt"></i>
            <span>Peta Desa</span>
        </a>
        <a href="../laporan/index.php" class="nav-item <?php echo strpos($current_page, 'laporan') !== false && strpos($current_path, 'admin') === false ? 'active' : ''; ?>">
            <i class="fas fa-file-alt"></i>
            <span>Laporan Warga</span>
        </a>
        <a href="distribusi.php" class="nav-item <?php echo strpos($current_page, 'distribusi') !== false && strpos($current_path, 'admin') !== false ? 'active' : ''; ?>">
            <i class="fas fa-truck"></i>
            <span>Manajemen Distribusi</span>
        </a>
        <a href="optimasi.php" class="nav-item <?php echo strpos($current_page, 'optimasi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-route"></i>
            <span>AI Optimasi Pengiriman</span>
        </a>
        <a href="users.php" class="nav-item <?php echo strpos($current_page, 'users') !== false ? 'active' : ''; ?>">
            <i class="fas fa-users"></i>
            <span>Kelola Pengguna</span>
        </a>
        <a href="desa.php" class="nav-item <?php echo strpos($current_page, 'desa') !== false ? 'active' : ''; ?>">
            <i class="fas fa-building"></i>
            <span>Kelola Desa</span>
        </a>
        <a href="depo.php" class="nav-item <?php echo strpos($current_page, 'depo') !== false ? 'active' : ''; ?>">
            <i class="fas fa-warehouse"></i>
            <span>Kelola Depo</span>
        </a>
        <a href="laporan.php" class="nav-item <?php echo strpos($current_page, 'laporan') !== false && strpos($current_path, 'admin') !== false ? 'active' : ''; ?>">
            <i class="fas fa-chart-bar"></i>
            <span>Laporan Sistem</span>
        </a>
        <a href="menu_icons.php" class="nav-item <?php echo strpos($current_page, 'menu_icons') !== false ? 'active' : ''; ?>">
            <i class="fas fa-palette"></i>
            <span>Kelola Menu</span>
        </a>
        <a href="wa_broadcast.php" class="nav-item <?php echo strpos($current_page, 'wa_broadcast') !== false ? 'active' : ''; ?>">
            <i class="fab fa-whatsapp"></i>
            <span>Broadcast WA</span>
        </a>
        <a href="pengaturan.php" class="nav-item <?php echo strpos($current_page, 'pengaturan') !== false ? 'active' : ''; ?>">
            <i class="fas fa-cog"></i>
            <span>Pengaturan Aplikasi</span>
        </a>
        <a href="hak_akses.php" class="nav-item <?php echo strpos($current_page, 'hak_akses') !== false ? 'active' : ''; ?>">
            <i class="fas fa-user-shield"></i>
            <span>Hak Akses</span>
        </a>
        <a href="error_check.php" class="nav-item <?php echo strpos($current_page, 'error_check') !== false ? 'active' : ''; ?>">
            <i class="fas fa-bug"></i>
            <span>Error Check</span>
        </a>
        <a href="../notifikasi/index.php" class="nav-item <?php echo strpos($current_page, 'notifikasi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-bell"></i>
            <span>Notifikasi</span>
            <?php
            $db = Database::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT COUNT(*) FROM notifikasi WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
            $stmt->execute([$_SESSION['user_id']]);
            $notif_count = $stmt->fetchColumn();
            if ($notif_count > 0):
            ?>
            <span class="badge" style="margin-left: auto;"><?php echo $notif_count; ?></span>
            <?php endif; ?>
        </a>
        
        <?php elseif (getUserRole() === 'warga'): ?>
        <!-- Warga Menu -->
        <a href="../prediksi/index.php" class="nav-item <?php echo strpos($current_page, 'prediksi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-chart-line"></i>
            <span>Prediksi Kekeringan</span>
        </a>
        <a href="../peta/index.php" class="nav-item <?php echo strpos($current_page, 'peta') !== false ? 'active' : ''; ?>">
            <i class="fas fa-map-marked-alt"></i>
            <span>Peta Desa</span>
        </a>
        <a href="../laporan/index.php" class="nav-item <?php echo strpos($current_page, 'laporan') !== false ? 'active' : ''; ?>">
            <i class="fas fa-file-alt"></i>
            <span>Buat Laporan</span>
        </a>
        <a href="../distribusi/warga.php" class="nav-item <?php echo strpos($current_page, 'warga') !== false && strpos($current_path, 'distribusi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-truck"></i>
            <span>Status Pengiriman</span>
        </a>
        <a href="../warga/profil.php" class="nav-item <?php echo strpos($current_page, 'profil') !== false ? 'active' : ''; ?>">
            <i class="fas fa-user"></i>
            <span>Profil Saya</span>
        </a>
        <a href="../notifikasi/index.php" class="nav-item <?php echo strpos($current_page, 'notifikasi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-bell"></i>
            <span>Notifikasi</span>
            <?php
            $db = Database::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT COUNT(*) FROM notifikasi WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
            $stmt->execute([$_SESSION['user_id']]);
            $notif_count = $stmt->fetchColumn();
            if ($notif_count > 0):
            ?>
            <span class="badge" style="margin-left: auto;"><?php echo $notif_count; ?></span>
            <?php endif; ?>
        </a>
        
        <?php elseif (getUserRole() === 'petugas_tangki'): ?>
        <!-- Petugas Menu -->
        <a href="../petugas/index.php" class="nav-item <?php echo strpos($current_page, 'petugas') !== false ? 'active' : ''; ?>">
            <i class="fas fa-truck"></i>
            <span>Laporan Pengiriman</span>
        </a>
        <a href="../notifikasi/index.php" class="nav-item <?php echo strpos($current_page, 'notifikasi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-bell"></i>
            <span>Notifikasi</span>
            <?php
            $db = Database::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT COUNT(*) FROM notifikasi WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
            $stmt->execute([$_SESSION['user_id']]);
            $notif_count = $stmt->fetchColumn();
            if ($notif_count > 0):
            ?>
            <span class="badge" style="margin-left: auto;"><?php echo $notif_count; ?></span>
            <?php endif; ?>
        </a>
        
        <?php elseif (getUserRole() === 'pemdes'): ?>
        <!-- Pemdes Menu -->
        <a href="../prediksi/index.php" class="nav-item <?php echo strpos($current_page, 'prediksi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-chart-line"></i>
            <span>Prediksi Kekeringan</span>
        </a>
        <a href="../laporan/index.php" class="nav-item <?php echo strpos($current_page, 'laporan') !== false ? 'active' : ''; ?>">
            <i class="fas fa-file-alt"></i>
            <span>Laporan Warga</span>
        </a>
        <a href="distribusi.php" class="nav-item <?php echo strpos($current_page, 'distribusi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-truck"></i>
            <span>Manajemen Distribusi</span>
        </a>
        <a href="../notifikasi/index.php" class="nav-item <?php echo strpos($current_page, 'notifikasi') !== false ? 'active' : ''; ?>">
            <i class="fas fa-bell"></i>
            <span>Notifikasi</span>
        </a>
        <?php endif; ?>
        
        <a href="<?php echo strpos($current_path, 'admin') !== false || strpos($current_path, 'petugas') !== false || strpos($current_path, 'distribusi') !== false || strpos($current_path, 'prediksi') !== false || strpos($current_path, 'peta') !== false || strpos($current_path, 'laporan') !== false || strpos($current_path, 'notifikasi') !== false ? '../auth/logout.php' : 'auth/logout.php'; ?>" class="nav-item">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </nav>
</aside>
