<?php
require_once '../config/config.php';

if (!isAdmin() && getUserRole() !== 'pemdes') {
    redirect('../dashboard.php');
}

$id = intval($_GET['id'] ?? 0);
if (!$id) {
    redirect('distribusi.php');
}

$db = Database::getInstance()->getConnection();

$stmt = $db->prepare("SELECT dt.*, dus.nama_dusun, dus.rt, dus.rw, dus.alamat as alamat_dusun, 
                    des.nama_desa, u.nama_lengkap as petugas, u2.nama_lengkap as approved_by_name
                    FROM distribusi_tangki dt
                    JOIN dusun dus ON dt.dusun_id = dus.id
                    JOIN desa des ON dus.desa_id = des.id
                    LEFT JOIN users u ON dt.petugas_id = u.id
                    LEFT JOIN users u2 ON dt.approved_by = u2.id
                    WHERE dt.id = ?");
$stmt->execute([$id]);
$dist = $stmt->fetch();

if (!$dist) {
    redirect('distribusi.php');
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Distribusi - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php if ($dist['latitude_bukti'] && $dist['longitude_bukti']): ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <?php endif; ?>
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="distribusi.php" class="nav-item active">
                <i class="fas fa-truck"></i>
                <span>Manajemen Distribusi</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-info-circle"></i> Detail Distribusi</h1>
                <p><?php echo htmlspecialchars($dist['nama_dusun']); ?></p>
            </div>
            <a href="distribusi.php" class="btn btn-primary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </header>

        <div class="content-section">
            <div class="form-row">
                <div class="form-group">
                    <label>Desa</label>
                    <input type="text" value="<?php echo htmlspecialchars($dist['nama_desa']); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Dusun</label>
                    <input type="text" value="<?php echo htmlspecialchars($dist['nama_dusun']); ?>" readonly>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Tanggal Jadwal</label>
                    <input type="text" value="<?php echo formatDate($dist['tanggal_jadwal']); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <?php
                    $status_class = 'info';
                    if ($dist['status'] === 'disetujui' || $dist['status'] === 'selesai') $status_class = 'success';
                    elseif ($dist['status'] === 'ditolak') $status_class = 'danger';
                    elseif ($dist['status'] === 'menunggu_approval') $status_class = 'warning';
                    ?>
                    <span class="badge badge-<?php echo $status_class; ?>" style="font-size: 1.1rem; padding: 10px 20px;">
                        <?php echo strtoupper(str_replace('_', ' ', $dist['status'])); ?>
                    </span>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Volume (Liter)</label>
                    <input type="text" value="<?php echo number_format($dist['volume_liter'] ?? 0); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Petugas</label>
                    <input type="text" value="<?php echo htmlspecialchars($dist['petugas'] ?? '-'); ?>" readonly>
                </div>
            </div>
            
            <?php if ($dist['status'] === 'ditolak' && !empty($dist['alasan_reject'])): ?>
            <div class="form-group">
                <label>Alasan Penolakan</label>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($dist['alasan_reject']); ?>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($dist['catatan'])): ?>
            <div class="form-group">
                <label>Catatan</label>
                <textarea readonly rows="3"><?php echo htmlspecialchars($dist['catatan']); ?></textarea>
            </div>
            <?php endif; ?>
            
            <?php if ($dist['approved_by_name']): ?>
            <div class="form-group">
                <label>Disetujui/Ditolak Oleh</label>
                <input type="text" value="<?php echo htmlspecialchars($dist['approved_by_name']); ?>" readonly>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($dist['foto_bukti'])): ?>
            <div class="form-group">
                <label>Foto Bukti Pengiriman</label>
                <div style="text-align: center;">
                    <img src="../<?php echo htmlspecialchars($dist['foto_bukti']); ?>" alt="Foto Bukti" style="max-width: 100%; max-height: 500px; border-radius: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.2);">
                    <br>
                    <a href="../<?php echo htmlspecialchars($dist['foto_bukti']); ?>" target="_blank" class="btn btn-primary" style="margin-top: 15px;">
                        <i class="fas fa-expand"></i> Lihat Full Size
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if ($dist['latitude_bukti'] && $dist['longitude_bukti']): ?>
            <div class="form-group">
                <label>Lokasi Pengiriman (Koordinat GPS)</label>
                <div class="form-row">
                    <div class="form-group">
                        <label>Latitude</label>
                        <input type="text" value="<?php echo number_format($dist['latitude_bukti'], 6); ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label>Longitude</label>
                        <input type="text" value="<?php echo number_format($dist['longitude_bukti'], 6); ?>" readonly>
                    </div>
                </div>
                <div id="map" style="height: 400px; margin-top: 15px;"></div>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <?php if ($dist['latitude_bukti'] && $dist['longitude_bukti']): ?>
    <script>
    const map = L.map('map').setView([<?php echo $dist['latitude_bukti']; ?>, <?php echo $dist['longitude_bukti']; ?>], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    L.marker([<?php echo $dist['latitude_bukti']; ?>, <?php echo $dist['longitude_bukti']; ?>])
        .addTo(map)
        .bindPopup('Lokasi Pengiriman<br><?php echo htmlspecialchars($dist['nama_dusun']); ?>')
        .openPopup();
    </script>
    <?php endif; ?>

    <script src="../assets/js/main.js"></script>
</body>
</html>

