<?php
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($username) || empty($password)) {
        $_SESSION['error'] = 'Username dan password harus diisi';
        redirect('../index.php');
    }

    $db = Database::getInstance()->getConnection();
    $stm = $db->prepare("SELECT * FROM users WHERE username = ? AND status = 'active' LIMIT 1");
    $stm->execute([$username]);
    $user = $stm->fetch();

    if ($user) {
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['nama_lengkap'] = $user['nama_lengkap'];
            $_SESSION['user_role'] = $user['role'];

            redirect('../dashboard.php');  // ✅ PERBAIKAN: dari './dashboard.php' menjadi '../dashboard.php'
        } else {
            $_SESSION['error'] = 'Password salah!';
            redirect('../index.php');
        }
    } else {
        $_SESSION['error'] = 'Username tidak ditemukan atau tidak aktif!';
        redirect('../index.php');
    }
} else {
    redirect('../index.php');
}